@echo off
title DCS Dedicated Server - Manager by ZetaS
color 0A

:: =========================
:: SELECCION DE IDIOMA
:: =========================
:IDIOMA
cls
echo ===========================================
echo        DCS DEDICATED SERVER - LANGUAGE
echo ===========================================
echo.
echo 1 - Spanish / Espanol
echo 2 - English / Ingles
echo.
echo X - Exit
echo.
choice /c 12X /n /m "Escriba 1, 2 o X: / Type 1, 2 or X: "
if errorlevel 3 goto SALIR
if errorlevel 2 set "IDIOMA=EN" & goto RUTA_MENU_EN
if errorlevel 1 set "IDIOMA=ES" & goto RUTA_MENU_ES

:: =========================
:: CONFIGURACION DE RUTA
:: =========================
:RUTA_MENU_ES
cls
    echo ===========================================
    echo       CONFIGURACION DE RUTA DCS
    echo ===========================================
	echo.
    echo 1 - Ruta por defecto (C:\Program Files\Eagle Dynamics\DCS World Server\bin)
    echo 2 - Ruta en Disco D: (D:\Eagle Dynamics\DCS World Server\bin)
    echo 3 - Ruta personalizada (Escriba manualmente la ruta a la carpeta "bin" SERVER!)
	echo.
	echo Y - Volver
	echo X - Salir
	echo.
)
echo.
choice /c 123YX /n /m " > "

if errorlevel 5 goto SALIR
if errorlevel 4 goto IDIOMA
if errorlevel 3 goto RUTA_CUSTOM
if errorlevel 2 set "DCS_PATH=D:\Eagle Dynamics\DCS World Server\bin" & goto MENU_CHECK
if errorlevel 1 set "DCS_PATH=C:\Program Files\Eagle Dynamics\DCS World Server\bin" & goto MENU_CHECK

:RUTA_MENU_EN
cls
    echo ===========================================
    echo          DCS PATH CONFIGURATION
    echo ===========================================
	echo.
    echo 1 - Default Path (C:\Program Files\Eagle Dynamics\DCS World Server\bin)
    echo 2 - D: Drive Path (D:\Eagle Dynamics\DCS World Server\bin)
    echo 3 - Custom Path (Type manually the path to the "bin" folder SERVER!)
	echo.
	echo Y - Back
	echo X - Exit
	echo.
)
echo.
choice /c 123YX /n /m " > "

if errorlevel 5 goto SALIR
if errorlevel 4 goto IDIOMA
if errorlevel 3 goto RUTA_CUSTOM
if errorlevel 2 set "DCS_PATH=D:\Eagle Dynamics\DCS World Server\bin" & goto MENU_CHECK
if errorlevel 1 set "DCS_PATH=C:\Program Files\Eagle Dynamics\DCS World Server\bin" & goto MENU_CHECK


:RUTA_CUSTOM
echo.
if "%IDIOMA%"=="ES" (set /p "DCS_PATH=Pega la ruta de la carpeta /bin de tu servidor: ") else (set /p "DCS_PATH=Paste the path to your server's /bin folder: ")

:MENU_CHECK
cd /d "%DCS_PATH%" 2>nul

:: Si el comando anterior fallo, saltamos al error
if %errorlevel% neq 0 goto ERROR_RUTA

:: Si todo va bien, saltamos al menu correspondiente
if "%IDIOMA%"=="ES" goto MENU_ES
if "%IDIOMA%"=="EN" goto MENU_EN

:ERROR_RUTA
echo.
if "%IDIOMA%"=="ES" (
    echo ERROR: La ruta no es valida o la carpeta no existe.
    echo Asegurate de que la ruta termina en ...\bin
    pause
    goto RUTA_MENU_ES
) else (
    echo ERROR: Invalid path or folder does not exist.
    echo Make sure the path ends in ...\bin
    pause
    goto RUTA_MENU_EN
)

:: =========================
:: MENU PRINCIPAL ESPAÑOL
:: =========================
:MENU_ES
cls
set "IDIOMA=ES"
echo ===========================================================
echo       DCS SERVER - GESTOR DE MAPAS by ZetaS v1.2 (ES)
echo ===========================================================
echo.
echo..................................-++++---##................
echo.-..-..--..-...-..--..-..--..-..--....#######..-...-..--..-.
echo..-..--..--..-..--..-..--..--..-..-..########.-..-..--..-...
echo.-..-..--..-...-..--..-..--..-..--..#########..-...-..--..-.
echo..-..--..--..-..--..-..--..--..-...##########.-..-..--......
echo.-..-..--..-..--..--..-..--..-....###########..-...-.....---
echo..-..--..--..-..--..-..--..--..-.############-...-.....#####
echo.-..-..--..-..--..--..-..--..-..#############-.......######+
echo..-..--..--..-..--..-..........##############+..-+#########+
echo.-..-..--..-............-#################################..
echo.............-############################################-.
echo.############++++++++-++#################################+-.
echo..-+######################################################+.
echo.-.............--+#######################################-..
echo..-..--..--..-..........-#################################-.
echo.-..-..--..-...-..--..-..-......#############+..-+#########+
echo 1 - Instalar mapa..-..--..--....############-...-...-######
echo 2 - Desinstalar mapa.-..--..-....###########-.-...-...-####
echo 3 - Reparar servidor...-..--..-...##########....-..--......
echo 4 - Actualizar servidor..-..-...-.-#########..-...-..--..-.
echo 5 - Listar modulos de terreno.-..-.-########.-..-..--..-...
echo Y - Volver......................-...-#######..-...-......-.
echo...............................-..-+++#######....-...-......
echo X - Salir........................-++++---##................
echo.
choice /c 12345YX /n /m "Selecciona una opcion: "

if errorlevel 7 goto SALIR
if errorlevel 6 goto IDIOMA
if errorlevel 5 goto LISTAR
if errorlevel 4 goto ACTUALIZAR
if errorlevel 3 goto REPARAR
if errorlevel 2 goto DESINSTALAR
if errorlevel 1 goto INSTALAR
goto MENU_ES

:: =========================
:: MENU PRINCIPAL ENGLISH
:: =========================
:MENU_EN
cls
set "IDIOMA=EN"
echo ===========================================================
echo         DCS SERVER - MAP MANAGER by ZetaS v1.2 (EN)
echo ===========================================================
echo.
echo..................................-++++---##................
echo...-..--..-...-..--..-..--..-..--....#######..-...-..--..-..
echo.-..--..--..-..--..-..--..--..-..-..########.-..-..--..-....
echo...-..--..-...-..--..-..--..-..--..#########..-...-..--..-..
echo.-..--..--..-..--..-..--..--..-...##########.-..-..--.......
echo...-..--..-..--..--..-..--..-....###########..-...-.....---.
echo.-..--..--..-..--..-..--..--..-.############-...-.....#####-
echo...-..--..-..--..--..-..--..-..#############-.......######+.
echo.-..--..--..-..--..-..........##############+..-+#########+.
echo...-..--..-............-#################################...
echo............-############################################-..
echo.###########++++++-++#################################+-..
echo.-+######################################################+..
echo..............--+#######################################-...
echo.-..--..--..-..........-#################################-..
echo...-..--..-...-..--..-..-......#############+..-+#########+.
echo 1 - Install map...-..--..--....############-...-...-######.
echo 2 - Uninstall map-..-..--..-....###########-.-...-...-####+
echo 3 - Server repair.-...-..--..-...##########....-..--.......
echo 4 - Server update...-..--..-...-..#########..-...-..--..-..
echo 5 - List terrain modules..-..-..-..########.-..-..--..-....
echo Y - Back....................-..-....#######..-...-......-..
echo............................-.-..-+++#######....-...-.......
echo X - Exit........................-++++---##.................
echo.
choice /c 12345YX /n /m "Select an option: "

if errorlevel 7 goto SALIR
if errorlevel 6 goto IDIOMA
if errorlevel 5 goto LISTAR
if errorlevel 4 goto ACTUALIZAR
if errorlevel 3 goto REPARAR
if errorlevel 2 goto DESINSTALAR
if errorlevel 1 goto INSTALAR
goto MENU_EN

:: =========================
:: MENU DE MAPAS
:: =========================
:MAPAS
cls
if "%IDIOMA%"=="ES" (
    echo ============================================
    echo           SELECCIONA UN MAPA
    echo ============================================
) else (
    echo ============================================
    echo             SELECT A MAP
    echo ============================================
)
echo.
echo A - Nevada (NTTR)          H - Sinai
echo B - Normandy 1944          I - Marianas
echo C - Normandy 2.0           J - Marianas WWII
echo D - The Channel            K - Kola Peninsula
echo E - Persian Gulf           L - Afghanistan
echo F - Syria                  M - Iraq
echo G - South Atlantic         N - Germany Cold War
echo.
if "%IDIOMA%"=="ES" (echo Y - Volver) else (echo Y - Back)
echo.
choice /c ABCDEFGHIJKLMNY /n /m " > "

if "%ERRORLEVEL%"=="1"  set "MAPA=NEVADA_terrain"
if "%ERRORLEVEL%"=="2"  set "MAPA=NORMANDY_terrain"
if "%ERRORLEVEL%"=="3"  set "MAPA=NORMANDY2_terrain"
if "%ERRORLEVEL%"=="4"  set "MAPA=THECHANNEL_terrain"
if "%ERRORLEVEL%"=="5"  set "MAPA=PERSIANGULF_terrain"
if "%ERRORLEVEL%"=="6"  set "MAPA=SYRIA_terrain"
if "%ERRORLEVEL%"=="7"  set "MAPA=FALKLANDS_terrain"
if "%ERRORLEVEL%"=="8"  set "MAPA=SINAIMAP_terrain"
if "%ERRORLEVEL%"=="9"  set "MAPA=MARIANAS_terrain"
if "%ERRORLEVEL%"=="10" set "MAPA=MARIANAISLANDSWWII_terrain"
if "%ERRORLEVEL%"=="11" set "MAPA=KOLA_terrain"
if "%ERRORLEVEL%"=="12" set "MAPA=AFGHANISTAN_terrain"
if "%ERRORLEVEL%"=="13" set "MAPA=IRAQ_terrain"
if "%ERRORLEVEL%"=="14" set "MAPA=GERMANYCW_terrain"
if "%ERRORLEVEL%"=="15" (
    if "%IDIOMA%"=="ES" (goto MENU_ES) else (goto MENU_EN)
)

goto %ACCION%_EJEC

:: =========================
:: INSTALAR
:: =========================
:INSTALAR
set "ACCION=INSTALAR"
goto MAPAS

:INSTALAR_EJEC
echo.
if "%IDIOMA%"=="ES" (echo Intentando instalar %MAPA%...) else (echo Installing %MAPA%...)
DCS_updater.exe install %MAPA%
pause
if "%IDIOMA%"=="ES" (goto MENU_ES) else (goto MENU_EN)

:: =========================
:: DESINSTALAR
:: =========================
:DESINSTALAR
set "ACCION=DESINSTALAR"
goto MAPAS

:DESINSTALAR_EJEC
echo.
if "%IDIOMA%"=="ES" (echo Intentando desinstalar %MAPA%...) else (echo Uninstalling %MAPA%...)
DCS_updater.exe uninstall %MAPA%
pause
if "%IDIOMA%"=="ES" (goto MENU_ES) else (goto MENU_EN)

:: =========================
:: REPARAR
:: =========================
:REPARAR
echo.
if "%IDIOMA%"=="ES" (echo Reparando servidor DCS...) else (echo Repairing DCS server...)
DCS_updater.exe repair
pause
if "%IDIOMA%"=="ES" (goto MENU_ES) else (goto MENU_EN)

:: =========================
:: ACTUALIZAR
:: =========================
:ACTUALIZAR
echo.
if "%IDIOMA%"=="ES" (echo Buscando actualizaciones para el servidor...) else (echo Checking for server updates...)
DCS_updater.exe update
echo.
pause
if "%IDIOMA%"=="ES" (goto MENU_ES) else (goto MENU_EN)

:: =========================
:: LISTAR
:: =========================
:LISTAR
goto LISTA_MAPAS

:: =========================
:: LISTA DE MAPAS (SOLO MOSTRAR)
:: =========================
:LISTA_MAPAS
cls
if "%IDIOMA%"=="ES" (
    echo ============================================
    echo          LISTADO DE MAPAS
    echo ============================================
) else (
    echo ============================================
    echo          LIST OF MAPS
    echo ============================================
)
echo.
echo A - Nevada (NTTR)
echo B - Normandy 1944
echo C - Normandy 2.0
echo D - The Channel
echo E - Persian Gulf
echo F - Syria
echo G - South Atlantic
echo H - Sinai
echo I - Marianas
echo J - Marianas WWII
echo K - Kola Peninsula
echo L - Afghanistan
echo M - Iraq
echo N - Germany Cold War
echo.
if "%IDIOMA%"=="ES" (echo Y - Volver) else (echo Y - Back)
echo.
choice /c Y /n /m " > "

if errorlevel 1 (
    if "%IDIOMA%"=="ES" (goto MENU_ES) else (goto MENU_EN)
)

goto %ACCION%_EJEC

:SALIR
exit